package de.hdm_stuttgart.mi.sd1.task2;

import de.hdm_stuttgart.mi.exam.reflect.ObjectWrapper;
import de.hdm_stuttgart.mi.exam.unitmarking.ExaminationTestDefaults;
import de.hdm_stuttgart.mi.exam.unitmarking.Points;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Order;
import org.junit.jupiter.api.Test;

/**
 * Test rectangles.
 */

public class TestGeometry extends ExaminationTestDefaults {


  @Test
  @Order(10)
  @Points(1)
  public void testPointConstructor() {
      final ObjectWrapper<Point> p = new ObjectWrapper<>(Point.class, 1., 2.); // (1.|2.)
  }

  @Test
  @Order(20)
  @Points(1)
  public void testPointAttributes() {
    final ObjectWrapper<Point> p = new ObjectWrapper<>(Point.class, 1., 2.); // (1.|2.)

    p.assertFieldExists(double.class, "x");
    p.assertFieldExists(double.class, "y");
  }
  @Test
  @Order(30)
  @Points(1)
  public void testPointValues() {
    {
      final ObjectWrapper<Point> p = new ObjectWrapper<>(Point.class, 1., 2.); // (1.|2.)
      Assertions.assertEquals(1, p.get(double.class, "x"));
      Assertions.assertEquals(2, p.get(double.class, "y"));
    }
    {
      final ObjectWrapper<Point> p = new ObjectWrapper<>(Point.class, -3.6, 1.7); // (-3.6|1.7)
      Assertions.assertEquals(-3.6, p.get(double.class, "x"));
      Assertions.assertEquals(1.7, p.get(double.class, "y"));
    }
  }

  @Test
  @Order(40)
  @Points(1)
  public void testPointImmutable() {
    final ObjectWrapper<Point> p = new ObjectWrapper<>(Point.class, 1., 2.); // (1.|2.)

    p.assertFieldExists(double.class, "x");
    p.assertFieldExists(double.class, "y");

    Assertions.assertEquals(1, p.get(double.class, "x"));
    Assertions.assertEquals(2, p.get(double.class, "y"));

    p.set("x", IllegalAccessException.class, 10.);
    p.set("y", IllegalAccessException.class, 10.);

  }

  @Test
  @Order(60)
  @Points(1)
  public void testPointPrint() {
    final ObjectWrapper<Point> p = new ObjectWrapper<>(Point.class, -2., 5.3); // (-2|5.3)
    Assertions.assertEquals("(-2.0|5.3)", p.getInstance().toString());
  }

  @Test
  @Order(120)
  @Points(1)
  public void testRectangleCreate() {

    final ObjectWrapper<Point> lowerLeftCorner = new ObjectWrapper<>(Point.class,3., 4.); // (3.|4.)
  }

  @Test
  @Order(130)
  @Points(1)
  public void testRectangleInsideOutside() {

    final ObjectWrapper<Point> lowerLeftCorner = new ObjectWrapper<>(Point.class,3., 4.); // (3.|4.)

    final  ObjectWrapper<Rectangle> rectangle =
            new ObjectWrapper<>(Rectangle.class,lowerLeftCorner, 7., 4.); // width + height

    Assertions.assertTrue(rectangle.invoke(boolean.class, "contains",
            new ObjectWrapper<>(Point.class,9., 4.))); // (9.|4.)

    Assertions.assertFalse(rectangle.invoke(boolean.class, "contains",
            new ObjectWrapper<>(Point.class,10., 9.))); // (9.|4.)

    Assertions.assertFalse(rectangle.invoke(boolean.class, "contains",
            new ObjectWrapper<>(Point.class,0., 0.))); // (9.|4.)
  }

  @Test
  @Order(140)
  @Points(1)
  public void testRectangleEdgeCorner() {

    final ObjectWrapper<Point> lowerLeftCorner = new ObjectWrapper<>(Point.class,1., 6.); // (1.|6.)

    final  ObjectWrapper<Rectangle> rectangle =
            new ObjectWrapper<>(Rectangle.class,lowerLeftCorner, 1., 3.); // width + height

    Assertions.assertFalse(rectangle.invoke(boolean.class, "contains",
            new ObjectWrapper<>(Point.class,-3., 5.))); // (-3|5)

    Assertions.assertTrue(rectangle.invoke(boolean.class, "contains",
            new ObjectWrapper<>(Point.class, 1., 6.))); // (1|6)

    Assertions.assertTrue(rectangle.invoke(boolean.class, "contains",
            new ObjectWrapper<>(Point.class, 1.5, 6.))); // (1.5|6)

    Assertions.assertTrue(rectangle.invoke(boolean.class, "contains",
            new ObjectWrapper<>(Point.class, 2., 6.))); // (2|6)

    Assertions.assertFalse(rectangle.invoke(boolean.class, "contains",
            new ObjectWrapper<>(Point.class, 2.001, 6.))); // (2.001|6)

    Assertions.assertFalse(rectangle.invoke(boolean.class, "contains",
            new ObjectWrapper<>(Point.class, 2., 5.9999998))); // (2|5.9999998)

    Assertions.assertTrue(rectangle.invoke(boolean.class, "contains",
            new ObjectWrapper<>(Point.class, 2., 7.5))); // (2|7.5)

    Assertions.assertTrue(rectangle.invoke(boolean.class, "contains",
            new ObjectWrapper<>(Point.class, 1.9998, 9.))); // (1.9998|9.)

    Assertions.assertTrue(rectangle.invoke(boolean.class, "contains",
            new ObjectWrapper<>(Point.class, 2., 8.999))); // (2.|8.999)

    Assertions.assertFalse(rectangle.invoke(boolean.class, "contains",
            new ObjectWrapper<>(Point.class, 2.002, 9.))); // (2.002|9.)

    Assertions.assertFalse(rectangle.invoke(boolean.class, "contains",
            new ObjectWrapper<>(Point.class, 2., 9.0001))); // (2.|9.0001)
  }

  @Test
  @Order(160)
  @Points(2)
  public void testRectangleNegatives() {

    final ObjectWrapper<Point> lowerLeft = new ObjectWrapper<>(Point.class,-1., -1.); // (-1.|-1.)

    final  ObjectWrapper<Rectangle> rectangle =
            new ObjectWrapper<>(Rectangle.class,lowerLeft, 4., 3.); // width + height

    Assertions.assertTrue(rectangle.invoke(boolean.class, "contains",
            new ObjectWrapper<>(Point.class, 0., 0.))); // (0|0)

    Assertions.assertFalse(rectangle.invoke(boolean.class, "contains",
            new ObjectWrapper<>(Point.class, 2., 6.))); // (2|6)

    Assertions.assertTrue(rectangle.invoke(boolean.class, "contains",
            new ObjectWrapper<>(Point.class, -1., -1.))); // (-1|-1)
  }
}
