package de.hdm_stuttgart.mi.sd1.task1;

/**
 * <p>Useful array methods.</p>
 */
public class ArrayHelper {


  /**
   * Creates an array of strings by concatenating a specified prefix with a range of integers.
   * Each element in the array is generated by appending a number from the provided range to the prefix.
   *
   * Example: <code>prefix = "test", from = 9, to= 11</code> yields an array <code>{"test9", "test10", "test11"}</code>.
   *
   * @param prefix The string to be prefixed to each number in the range.
   * @param from The starting integer (inclusive) of the range.
   * @param to The ending integer (inclusive) of the range.
   * @return An array of strings where each element is the prefix concatenated with the numbers from the specified range.
   */
  static public String[] create(String prefix, int from, int to) {
    final  String[] result = new String[to - from + 1];
    for (int i = from; i <= to; i++) {
      result[i - from] = prefix + i;
    }
    return result;
  }

  /**
   * <p>Strip <code>null</code> values.</p>
   *
   *
   * <p>Remove all <code>null</code> values from an array and return all remaining elements. Example:</p>
   *
   * <p><code>{"This", null, "is", "a", "test", null}</code> will be stripped to
   *   <code>{"This", "is", "a", "test"}</code></p>
   *
   * @param array An array possibly containing <code>null</code> values.
   * @return A potentially shorter array containing only non-<code>null</code> values.
   */
  static public String[] stripNulls(final String[] array) {

    // Step 1: Count the number of null values
    int numberOfNulls = 0;
    for (final String s: array) {
      if (null == s) {
        numberOfNulls++;
      }
    }

    if (numberOfNulls == 0) {
      // Step 2a: No null value found, just return the original array.
      return array;
    }  else {

      // Step 2b: Create a smaller array for hosting all non-null values
      final String[] result = new String[array.length - numberOfNulls];

      // Step 3: Copy non-null values
      int index = 0;
      for (final String s: array) {
        if (null != s) {
          result[index++] = s;
        }
      }
      return result;
    }
  }

  private ArrayHelper() {/* Ignore me, I just prohibit Javadoc-related warnings */}
}
