package de.hdm_stuttgart.mi.sd1.task1;

/**
 * Splitting array values.
 */
public class ArraySelect {

    /**
     * <p>Selecting array values based on either even or odd index values.</p>
     *
     * <p>Consider:</p>
     *
     * <table class="goikTableDefaults">
     *   <caption>Sample array values among with <span class="myRed">even</span> and <span class="myGreen">odd</span>
     *            indexes</caption>
     *     <tr>
     *         <th>Array values</th>
     *         <td><pre>int[] array = {<span class="myRed">22</span>, <span class="myGreen">33</span>, <span class="myRed">44</span>, <span class="myGreen">55</span>, <span class="myRed">66</span>, <span class="myGreen">77</span>, <span class="myRed">88</span>}</pre></td>
     *     </tr>
     *     <tr>
     *         <th>Array indexes</th>
     *         <td><pre>                <span class="myRed">0</span>   <span class="myGreen">1</span>   <span class="myRed">2</span>   <span class="myGreen">3</span>   <span class="myRed">4</span>   <span class="myGreen">5</span>   <span class="myRed">6</span></pre></td>
     *     </tr>
     *     <tr>
     *         <th>Result for <span class="myRed">even</span> indexes:<br><code class="myRed">selectEvenIndexes == true</code></th>
     *         <td><pre class="myRed"
     *                 >              {22,     44,     66,     88}</pre></td>
     *     </tr>
     *     <tr>
     *         <th>Result for <span class="myGreen">odd</span> indexes:<br><code class="myGreen">selectEvenIndexes == false</code></th>
     *         <td><pre class="myGreen"
     *                 >                  {33,     55,     77}</pre></td>
     *     </tr>
     * </table>
     *
     * @param selectEvenIndexes If <code>true</code>, select even index positions or odd ones otherwise.
     * @param array A list of input values or <code>null</code>.
     * @return An array of values corresponding to either even or odd array index positions. In case of
     *       <code>null</code> input array an <b>empty</b> array is being returned.
     *
     * <br>
     *
     * <section class="implementationHints">
     *   <h4 class="implementationHints">Hint:</h4>
     *
     *   <p>By defining <code style="font-weight: bold">int arrayLength = array.length</code>, the two possible
     *      output array lengths are given by:</p>
     *
     *   <dl>
     *       <dt><b>Even index positions:</b></dt>
     *       <dd><code>(arrayLength + 1) / 2</code></dd>
     *
     *       <dt><b>Odd index positions:</b></dt>
     *       <dd><code>arrayLength / 2</code></dd>
     *   </dl>
     *
     * </section>
     */
    static public int[] select(boolean selectEvenIndexes, int[] array) {
        if (null == array) {
            return new int[0];
        }
        final int
                arrayLength = array.length,
                resultArrayLength,
                startIndex;

        if (selectEvenIndexes) {
            resultArrayLength = (arrayLength + 1) / 2 ;
            startIndex = 0;
        } else {
            resultArrayLength = arrayLength / 2;
            startIndex = 1;
        }
        final int[] resultArray = new int[resultArrayLength];

        int resultIndex = 0;
        for (int i = startIndex; i < array.length; i += 2) {
            resultArray[resultIndex++] = array[i];
        }
        return resultArray;
    }

    private ArraySelect() {/* Ignore me: My sole purpose is suppressing default constructor javadoc warnings */}
}
