# Troubleshooting

1. **Your IntelliJ IDE freezes / hangs:**

   Grab a terminal window and execute:
    ```bash
    killall idea
    ```
   Wait some seconds, then restart IntelliJ.

# Generate and open class/method Javadoc for browsing

1. **By command in a terminal:**

   Grab a terminal in Idea (By lower-left icon or Alt+F12) and issue / click green arrow `mvn javadoc:javadoc`:

    <pre>mvn javadoc:javadoc
    ...
    [<span style="color:blue;font-weight:bold;">INFO</span>] Executing tasks
    [<span style="color:orange;font-weight:bold;">WARNING</span>]  [echo] Javadoc root at <span style="color:blue;">file:///home/.../Exam/target/reports/apidocs/index.html</span>
    [<span style="color:blue;font-weight:bold;">INFO</span>] Executed tasks
    ...</pre>

2. **By Idea GUI:**

    a) Hit the Maven 
       <span style="font-size: x-large;font-style: italic; background: #F7F8Fa;color: #6C707E;">m</span> icon
       on top of Idea's right side panel

    b) Open the e.g., »Summer 2025 exam« entry.

    c) Open Plugins

    d) Open Javadoc

    e) Double click on `javadoc:javadoc`

Click on or copy the <span style="color: blue;">file:///.../index.html</span> link for opening your project's 
Javadoc `index.html` root file in your web browser.

# Implementation tasks

Your project's packages _typically_ contain implementation task packages:

- `de.hdm_stuttgart.mi.sd1.task1` (typically 50 Points)

- `de.hdm_stuttgart.mi.sd1.task2` (typically 20 points, harder tasks)

Read the generated Javadoc and implement the skeleton methods and classes.

Your project's `test` branch does contain corresponding unit tests for verifying your solutions' correctness.

# Hints

- Execution of »ShowReachedPoints« in your »test« branch provides your exact current score. It executes tests in the
  author's opinion ascending order of difficulty.

- Your score solely depends on the number of successfully executing unit tests. A »nearly correct« implementation
  failing with respect to a unit test contributes no points at all.

- General advice: Implement less but correctly.

- Mind special cases i.e. `null` variable values or null values being contained in arrays.

- In case of test failures, both the IDEA debugger and logging statements are your friend.

- Do not model your implementations along unit test definitions, i.e., avoid cheating this way! Such behavior will be
  flagged as an attempt at deception (Täuschungsversuch)!

# Exam system upload

After finishing implementing:

1. Export this project by hitting **»File ➔ Export ➔ Project to Zip File«**.
2. Use a self-explanatory file name like e.g. `solution1.zip`. 
3. Go to your exam browser window and upload `solution1.zip` .
4. If you advance on implementing: Repeat steps 1. to 3. thus overriding earlier submissions.
